﻿/*
	VERSION:		1.4
	
	
	NOTE:
		You can optionally specify a movieClip target.
		That way, only double-clicking that movieClip will trigger the double-click event.
		
		
	REMOVAL:
		doubleClick.shutDown();
		delete doubleClick;
		
		
	USAGE 1:
		doubleClick = new DoubleClick();
		doubleClick.onDoubleClick = function()
		{
			trace("double click");
		}
		
		
	USAGE 1b:
		doubleClick = new DoubleClick( my_mc );
		doubleClick.onDoubleClick = function()
		{
			trace("double click");
		}
	
	
	USAGE 2:
		doubleClick = new DoubleClick();
		doubleClick.addListener( this );
		this.onDoubleClick = function()
		{
			trace("double click");
		}
*/
class DoubleClick
{
	var maxDistance = 16;						// pixels.  How close the 2 clicks need to be to each other
	var maxDelay = 1000/4.5;				// milliseconds.  How fast the double-click needs to be, to be valid
	var oldX:Number;
	var oldY:Number;
	var broadcastMessage:Function;	// Allows events to be broadcast
	var onDoubleClick:Function;			// externally-defined function
	var delay;											// ID number used to cancel the delay timeout
	var target;											// movieClip to be clicked on
	function DoubleClick( newTarget )
	{
		target = newTarget;
		AsBroadcaster.initialize( this );
		Mouse.addListener( this );
		this.timeOut( this );
	}// CONSTRUCTOR
	function shutDown()
	{
		Mouse.removeListener( this );
	}// PSEUDO-DESTRUCTOR		(does not remove the object)
	
	function onMouseUp()
	{
		// if this click is near the previous one  &  timeOut hasn't expired
		var newX = _root._xmouse;
		var newY = _root._ymouse;
		var diffX = newX - this.oldX;
		var diffY = newY - this.oldY;
		var clickDistance = Math.sqrt( (diffX*diffX) + (diffY*diffY) );
		var targetClicked = (target) ? target.hitTest( newX, newY ) : true;
		if( targetClicked  &&  clickDistance < this.maxDistance)
		{// if:  nearby  &  is clicking the target
			this.onDoubleClick();
			this.broadcastMessage( "onDoubleClick" );
			// reset double-click
			this.timeOut( this );
			clearTimeout( delay );
		}else{
			// remember this click location
			this.oldX = newX;
			this.oldY = newY;
			// start waiting for double-click
			delay = _global.setTimeout( timeOut, maxDelay, this );		// calls timeOut() 1/4 of a second later
		}// if:  far away  OR  is not clicking the target
	}// click()
	
	function timeOut( _this )
	{
		// _this   is needed because this function is called by setTimeout(),   a _global function which has NO access to this class's variables!   
		// ...so a reference is needed to access them.
		_this.oldX = 99999;
		_this.oldY = 99999;
	}// timeOut()
}// DoubleClick
